# import libraries
import numpy as np
from matplotlib import pyplot as plt

# Loading results files
kinematics          = np.loadtxt("resultsR/dirdyn_kinematics.res")
kinematics[:,3]    -= 0.278

# plotting
#plt.title("Results Five-Link Suspension")
f, axarr = plt.subplots(4, sharex=True, num="Python")


axarr[0].set_title("Steer angle")
axarr[0].set_ylabel('steer angle [º]')
axarr[0].set_xlabel('[m]')
axarr[0].plot(kinematics[:,3], kinematics[:,5]*180/np.pi)
axarr[0].set_ylim(-4,8)

axarr[1].set_title("Camber angle")
axarr[1].set_ylabel('camber angle [º]')
axarr[1].set_xlabel('[m]')
axarr[1].plot(kinematics[:,3], kinematics[:,4]*180/np.pi)
axarr[1].set_ylim(-10,2)

axarr[2].set_title("X position of the wheel")
axarr[2].set_ylabel('x-coord [m]')
axarr[2].set_xlabel('[m]')
axarr[2].plot(kinematics[:,3], kinematics[:,1])
axarr[2].set_ylim(-0.012,0.006)

axarr[3].set_title("Y position of the wheel")
axarr[3].set_ylabel('y-coord [m]')
axarr[3].set_xlabel('[m]')
axarr[3].plot(kinematics[:,3], kinematics[:,2])
axarr[3].set_ylim(0.680,0.770)

plt.subplots_adjust(left=0.25, bottom=0.08, right=0.85, top=0.96, wspace=None, hspace=0.35)
plt.xlim(-0.2,0.2)

plt.show()
